import React from "react";
import UserForm from "./UserForm";

export default class UserItem extends React.Component{

    constructor(props){
        super(props)
        this.state = {
            isSelected: false
        }
    }

    delete = () => {
        console.log('deletar o id ' + this.props.user._id)
        this.props.delete(this.props.user._id)
    }

    select = () => {
        console.log(this.props.user)
        this.setState({
            isSelected: !this.state.isSelected
        })
    }

    update = (user) => {
        user._id = this.props.user._id
        this.setState({
            isSelected: false
        })
        this.props.update(user)
    }

    render(){
        let user = this.props.user
        let form = this.state.isSelected ? <UserForm confirm={this.update} name={this.props.user.name} password={this.props.user.password} nomeBotao="Salvar"></UserForm> : null
        return <li>
            {user.name}
            ({user.password})
            <input type="button" onClick={this.delete} value="deletar"></input>
            <input type="button" onClick={this.select} value="editar"></input>
            {form}
        </li>
    }
}