import React from "react";

export default class UserForm extends React.Component{

    constructor(props){
        super(props)
        this.state = {
            name: this.props.name,
            password: this.props.password
        }
    }

    submit = (event) => {
        event.preventDefault()
        let user = this.state
        this.props.confirm(user)
        this.setState({
            name: "",
            password: ""
        })
    }

    handleInput = (event) => {
        this.setState({
            [event.target.name]: event.target.value
        })
    }

    render(){
        let nomeBotao = this.props.nomeBotao || "Cadastrar"
        return <form onSubmit={this.submit}>
            <input type="text" onChange={this.handleInput} value={this.state.name} name="name" id="name" placeholder="Nome de usuário"></input>
            <input type="password" onChange={this.handleInput} value={this.state.password} name="password" id="password" placeholder="Senha"></input>
            <input type="submit" value={nomeBotao}></input>
        </form>
    }
}