import React from "react";
import UserList from './UserList'
import Axios from 'axios'
import UserForm from "./UserForm";

export default class UserPage extends React.Component{
    constructor(props){
        super(props)
        this.BASE_URL = 'http://localhost:4000/api/users'
        this.state = {
            users: []
        }
    }

    componentDidMount(){
        this.getAllUsers()
    }

    getAllUsers = async () => {
        try{
            let resultado = await Axios.get(this.BASE_URL)
            this.setState({
                users: resultado.data
            })
        } catch (err){
            console.log(err.message)
        }
    }

    saveUser = async (user) => {
        try{
            let resultado = await Axios.post(this.BASE_URL, user)
            this.getAllUsers()
        } catch (err){
            console.log(err.message)
        }
    }

    deleteUser = async (userId) => {
        try{
            let resultado = await Axios.delete(this.BASE_URL + '/' + userId)
            this.getAllUsers()
        } catch (err){
            console.log(err.message)
        }
    }

    render(){
        return <main>
            <h1>Usuários</h1>
            <section>
                <UserForm confirm={this.saveUser}></UserForm>
            </section>
            <section>
                <UserList users={this.state.users} delete={this.deleteUser}></UserList>
            </section>
        </main>
    }
}