const express = require('express')
const router = express.Router()
const Personagem = require('../models/Personagem')

// Retornar todos os personagens
router.get('/', async (req, res) =>{
    var nLimit = parseInt(req.query.limit) || 10
    var nSkip = parseInt(req.query.skip)
    const personagens = await Personagem.find().limit(nLimit).skip(nSkip)
    res.json(personagens)
})

// Retornar um personagem especifico
router.get('/:id', async (req, res, next) => {
    try{
        const id = req.params.id
        var personagem = await Personagem.findById(id)
        if(!personagem) return res.status(404).json({
            "erro": "Personagem não encontrado"
        })
        res.json(personagem)
    } catch(err){
        next(err)
    }
})

// Inserir um novo personagem
router.post('/', async (req, res) => {
    const personagem = new Personagem(req.body)
    var resultado = await personagem.save()
    return res.json(personagem)
})

// Substituir um personagem
router.put('/:id', async (req, res) => {
    const id = req.params.id
    const novoPersonagem = req.body
    const atualPersonagem = await Personagem.findByIdAndUpdate(id, novoPersonagem, {new: true})
    return res.json(atualPersonagem)
})

// Deletar um personagem
router.delete('/:id', async (req, res) => {
    const id = req.params.id
    const personagem = await Personagem.findByIdAndDelete(id)
    res.json(personagem)
})

module.exports = router